// config: norepeat

#include "GetObjects.js"
#include "GetPoint.js"

function DoMirror()
{
	var objectpicker = moi.ui.createObjectPicker();
	objectpicker.allowEditPoints();
	
	if ( !GetObjects( objectpicker ) )
		return;
		
	var objects = objectpicker.objects;

	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SelectObjectsPrompt' );
	moi.ui.hideUI( 'done' );
	moi.ui.showUI( 'StartPointPrompt' );
	moi.ui.showUI( 'MirrorOptions' );
	moi.ui.endUIUpdate();

	var pointpicker = moi.ui.createPointPicker();
	if ( !GetPoint( pointpicker ) )
		return;
		
	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'StartPointPrompt' );
	moi.ui.showUI( 'EndPointPrompt' );
	moi.ui.endUIUpdate();

	var factory = moi.command.createFactory( 'mirror' );
	
	factory.setInput( 0, objects );
	factory.setInput( 1, pointpicker.ptframe );
	
	moi.ui.bindUIToInput( 'deleteinputs', 'value', factory.getInput(3) );

	pointpicker.restrictToPlaneThroughPt( pointpicker.pt, false );
	pointpicker.stickToSurfacesMode = 'min';
	pointpicker.disableVerticalStraightSnap = true;

	pointpicker.bindResultPt( factory.getInput(2) );
	pointpicker.bindResultOrientation( factory.getInput(1) );

	if ( !GetPoint( pointpicker ) )
		return;
		
	factory.commit();
}

DoMirror();
